/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.entities.MutantShulkerTrap;
import com.alexander.mutantmore.entities.MutantShulkerTurret;
import com.alexander.mutantmore.init.EntityTypeInit;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.util.MiscUtils;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class CustomShulkerBullet
extends Projectile {
    @Nullable
    private Entity finalTarget;
    @Nullable
    private Direction currentMoveDirection;
    private int flightSteps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;
    @Nullable
    private UUID targetId;
    public float damage = 0.0f;
    public int levitationLength = 0;
    public int levitationLevel = 0;

    public CustomShulkerBullet(EntityType<? extends CustomShulkerBullet> p_37319_, Level p_37320_) {
        super(p_37319_, p_37320_);
        this.f_19794_ = true;
    }

    public CustomShulkerBullet(Level p_37330_, LivingEntity p_37331_, Entity p_37332_, Direction.Axis p_37333_) {
        this((EntityType<? extends CustomShulkerBullet>)((EntityType)EntityTypeInit.CUSTOM_SHULKER_BULLET.get()), p_37330_);
        this.m_5602_((Entity)p_37331_);
        BlockPos blockpos = p_37331_.m_20183_();
        double d0 = (double)blockpos.m_123341_() + 0.5;
        double d1 = (double)blockpos.m_123342_() + 0.5;
        double d2 = (double)blockpos.m_123343_() + 0.5;
        this.m_7678_(d0, d1, d2, this.m_146908_(), this.m_146909_());
        this.finalTarget = p_37332_;
        this.currentMoveDirection = Direction.UP;
        this.selectNextMoveDirection(p_37333_);
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected void m_7380_(CompoundTag p_37357_) {
        super.m_7380_(p_37357_);
        if (this.finalTarget != null) {
            p_37357_.m_128362_("Target", this.finalTarget.m_20148_());
        }
        if (this.currentMoveDirection != null) {
            p_37357_.m_128405_("Dir", this.currentMoveDirection.m_122411_());
        }
        p_37357_.m_128405_("Steps", this.flightSteps);
        p_37357_.m_128347_("TXD", this.targetDeltaX);
        p_37357_.m_128347_("TYD", this.targetDeltaY);
        p_37357_.m_128347_("TZD", this.targetDeltaZ);
        p_37357_.m_128350_("Damage", this.damage);
        p_37357_.m_128405_("LevitationLength", this.levitationLength);
        p_37357_.m_128405_("LevitationLevel", this.levitationLevel);
    }

    protected void m_7378_(CompoundTag p_37353_) {
        super.m_7378_(p_37353_);
        this.flightSteps = p_37353_.m_128451_("Steps");
        this.targetDeltaX = p_37353_.m_128459_("TXD");
        this.targetDeltaY = p_37353_.m_128459_("TYD");
        this.targetDeltaZ = p_37353_.m_128459_("TZD");
        if (p_37353_.m_128425_("Dir", 99)) {
            this.currentMoveDirection = Direction.m_122376_((int)p_37353_.m_128451_("Dir"));
        }
        if (p_37353_.m_128403_("Target")) {
            this.targetId = p_37353_.m_128342_("Target");
        }
        this.damage = p_37353_.m_128457_("Damage");
        this.levitationLength = p_37353_.m_128451_("LevitationLength");
        this.levitationLevel = p_37353_.m_128451_("LevitationLevel");
    }

    protected void m_8097_() {
    }

    @Nullable
    private Direction getMoveDirection() {
        return this.currentMoveDirection;
    }

    private void setMoveDirection(@Nullable Direction p_37351_) {
        this.currentMoveDirection = p_37351_;
    }

    private void selectNextMoveDirection(@Nullable Direction.Axis p_37349_) {
        BlockPos blockpos;
        double d0 = 0.5;
        if (this.finalTarget == null) {
            blockpos = this.m_20183_().m_7495_();
        } else {
            d0 = (double)this.finalTarget.m_20206_() * 0.5;
            blockpos = new BlockPos(this.finalTarget.m_20185_(), this.finalTarget.m_20186_() + d0, this.finalTarget.m_20189_());
        }
        double d1 = (double)blockpos.m_123341_() + 0.5;
        double d2 = (double)blockpos.m_123342_() + d0;
        double d3 = (double)blockpos.m_123343_() + 0.5;
        Direction direction = null;
        if (!blockpos.m_203195_((Position)this.m_20182_(), 2.0)) {
            BlockPos blockpos1 = this.m_20183_();
            ArrayList list = Lists.newArrayList();
            if (p_37349_ != Direction.Axis.X) {
                if (blockpos1.m_123341_() < blockpos.m_123341_() && this.f_19853_.m_46859_(blockpos1.m_122029_())) {
                    list.add(Direction.EAST);
                } else if (blockpos1.m_123341_() > blockpos.m_123341_() && this.f_19853_.m_46859_(blockpos1.m_122024_())) {
                    list.add(Direction.WEST);
                }
            }
            if (p_37349_ != Direction.Axis.Y) {
                if (blockpos1.m_123342_() < blockpos.m_123342_() && this.f_19853_.m_46859_(blockpos1.m_7494_())) {
                    list.add(Direction.UP);
                } else if (blockpos1.m_123342_() > blockpos.m_123342_() && this.f_19853_.m_46859_(blockpos1.m_7495_())) {
                    list.add(Direction.DOWN);
                }
            }
            if (p_37349_ != Direction.Axis.Z) {
                if (blockpos1.m_123343_() < blockpos.m_123343_() && this.f_19853_.m_46859_(blockpos1.m_122019_())) {
                    list.add(Direction.SOUTH);
                } else if (blockpos1.m_123343_() > blockpos.m_123343_() && this.f_19853_.m_46859_(blockpos1.m_122012_())) {
                    list.add(Direction.NORTH);
                }
            }
            direction = Direction.m_235672_((RandomSource)this.f_19796_);
            if (list.isEmpty()) {
                for (int i = 5; !this.f_19853_.m_46859_(blockpos1.m_121945_(direction)) && i > 0; --i) {
                    direction = Direction.m_235672_((RandomSource)this.f_19796_);
                }
            } else {
                direction = (Direction)list.get(this.f_19796_.m_188503_(list.size()));
            }
            d1 = this.m_20185_() + (double)direction.m_122429_();
            d2 = this.m_20186_() + (double)direction.m_122430_();
            d3 = this.m_20189_() + (double)direction.m_122431_();
        }
        this.setMoveDirection(direction);
        double d6 = d1 - this.m_20185_();
        double d7 = d2 - this.m_20186_();
        double d4 = d3 - this.m_20189_();
        double d5 = Math.sqrt(d6 * d6 + d7 * d7 + d4 * d4);
        if (d5 == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = d6 / d5 * 0.15;
            this.targetDeltaY = d7 / d5 * 0.15;
            this.targetDeltaZ = d4 / d5 * 0.15;
        }
        this.f_19812_ = true;
        this.flightSteps = 10 + this.f_19796_.m_188503_(5) * 10;
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            HitResult hitresult;
            if (this.finalTarget == null && this.targetId != null) {
                this.finalTarget = ((ServerLevel)this.f_19853_).m_8791_(this.targetId);
                if (this.finalTarget == null) {
                    this.targetId = null;
                }
            }
            if (this.finalTarget == null || !this.finalTarget.m_6084_() || this.finalTarget instanceof Player && this.finalTarget.m_5833_()) {
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
                }
            } else {
                this.targetDeltaX = Mth.m_14008_((double)(this.targetDeltaX * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaY = Mth.m_14008_((double)(this.targetDeltaY * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaZ = Mth.m_14008_((double)(this.targetDeltaZ * 1.025), (double)-1.0, (double)1.0);
                Vec3 vec3 = this.m_20184_();
                this.m_20256_(vec3.m_82520_((this.targetDeltaX - vec3.f_82479_) * 0.2, (this.targetDeltaY - vec3.f_82480_) * 0.2, (this.targetDeltaZ - vec3.f_82481_) * 0.2));
            }
            if ((hitresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_)).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
        }
        this.m_20101_();
        Vec3 vec31 = this.m_20184_();
        this.m_6034_(this.m_20185_() + vec31.f_82479_, this.m_20186_() + vec31.f_82480_, this.m_20189_() + vec31.f_82481_);
        ProjectileUtil.m_37284_((Entity)this, (float)0.5f);
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_ + 0.15, this.m_20189_() - vec31.f_82481_, 0.0, 0.0, 0.0);
        } else if (this.finalTarget != null && !this.finalTarget.m_213877_()) {
            if (this.flightSteps > 0) {
                --this.flightSteps;
                if (this.flightSteps == 0) {
                    this.selectNextMoveDirection(this.currentMoveDirection == null ? null : this.currentMoveDirection.m_122434_());
                }
            }
            if (this.currentMoveDirection != null) {
                BlockPos blockpos = this.m_20183_();
                Direction.Axis direction$axis = this.currentMoveDirection.m_122434_();
                if (this.f_19853_.m_46575_(blockpos.m_121945_(this.currentMoveDirection), (Entity)this)) {
                    this.selectNextMoveDirection(direction$axis);
                } else {
                    BlockPos blockpos1 = this.finalTarget.m_20183_();
                    if (direction$axis == Direction.Axis.X && blockpos.m_123341_() == blockpos1.m_123341_() || direction$axis == Direction.Axis.Z && blockpos.m_123343_() == blockpos1.m_123343_() || direction$axis == Direction.Axis.Y && blockpos.m_123342_() == blockpos1.m_123342_()) {
                        this.selectNextMoveDirection(direction$axis);
                    }
                }
            }
        }
    }

    protected boolean m_5603_(Entity target) {
        return this.canHit(target) && super.m_5603_(target) && !target.f_19794_;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6783_(double p_37336_) {
        return p_37336_ < 16384.0;
    }

    public float m_213856_() {
        return 1.0f;
    }

    protected void m_5790_(EntityHitResult p_37345_) {
        LivingEntity livingentity;
        boolean flag;
        super.m_5790_(p_37345_);
        Entity entity = p_37345_.m_82443_();
        Entity entity1 = this.m_37282_();
        if (this.canHarm(entity) && (flag = entity.m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)(livingentity = entity1 instanceof LivingEntity ? (LivingEntity)entity1 : null)).m_19366_(), this.damage))) {
            this.m_19970_(livingentity, entity);
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).m_147207_(new MobEffectInstance(MobEffects.f_19620_, this.levitationLength, this.levitationLevel), (Entity)MoreObjects.firstNonNull((Object)entity1, (Object)((Object)this)));
            }
        }
    }

    boolean canHarm(Entity target) {
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_SHULKER_TRAP_SHULKER_BULLET_CANT_HURT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof MutantShulkerTrap)) {
            return true;
        }
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_SHULKER_TURRET_SHULKER_BULLET_CANT_HURT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof MutantShulkerTurret)) {
            return true;
        }
        return MiscUtils.canHarmBasedOnTeamAndTag(null, (Entity)this, target, this.m_37282_(), entity -> !(entity instanceof MutantShulkerTrap) && !(entity instanceof MutantShulkerTurret));
    }

    boolean canHit(Entity target) {
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_SHULKER_TRAP_SHULKER_BULLET_CANT_HIT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof MutantShulkerTrap)) {
            return true;
        }
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_SHULKER_TURRET_SHULKER_BULLET_CANT_HIT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof MutantShulkerTurret)) {
            return true;
        }
        return MiscUtils.canHarmBasedOnTeamAndTag(null, (Entity)this, target, this.m_37282_(), entity -> !(entity instanceof MutantShulkerTrap) && !(entity instanceof MutantShulkerTurret));
    }

    protected void m_8060_(BlockHitResult p_37343_) {
        super.m_8060_(p_37343_);
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 0.2, 0.2, 0.2, 0.0);
        this.m_5496_(SoundEvents.f_12410_, 1.0f, 1.0f);
    }

    protected void m_6532_(HitResult p_37347_) {
        super.m_6532_(p_37347_);
        this.m_146870_();
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6469_(DamageSource p_37338_, float p_37339_) {
        if (!this.f_19853_.f_46443_) {
            this.m_5496_(SoundEvents.f_12411_, 1.0f, 1.0f);
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.2, 0.2, 0.2, 0.0);
            this.m_146870_();
        }
        return true;
    }

    public void m_141965_(ClientboundAddEntityPacket p_150185_) {
        super.m_141965_(p_150185_);
        double d0 = p_150185_.m_131503_();
        double d1 = p_150185_.m_131504_();
        double d2 = p_150185_.m_131505_();
        this.m_20334_(d0, d1, d2);
    }
}

